//
//  OPDisplayOrderedList.h
//  OnePasswordiOS
//
//  Created by Dave Teare on 12-03-15.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <OnePasswordCore/OnePasswordCore.h>

@class OPDatabaseObject;

@interface OPDisplayOrderableList : NSObject {
	NSMutableArray *_items;
}

@property (nonatomic, readonly) NSUInteger count;
@property (nonatomic, readonly, getter = isEmpty) BOOL empty;

- (id)initWithArray:(NSArray *)itemArray;

- (id)objectAtIndex:(NSUInteger)index;
- (NSUInteger)indexOfObjectWithId:(OPID)oid;
- (NSUInteger)indexOfItemWithUUID:(NSString *)uuid;

- (BOOL)needsSaving;

- (NSArray *)items;
- (NSSet *)allIds;
- (NSSet *)allUUIDs;

- (void)moveItemAtIndex:(NSUInteger)fromIndex toIndex:(NSUInteger)toIndex;
- (void)removeItemAtIndex:(NSUInteger)index;
- (void)appendItem:(OPDatabaseObject *)item;

- (void)resetDisplayOrder;

@end
